class Task_type_handler:
    def __init__(self, tasks: list):
        self._idx2key = tasks
        self._key2idx = {t: i for i, t in enumerate(tasks)}

    def __getitem__(self, item):
        if type(item) == str:
            return self._key2idx[item]
        elif type(item) == int:
            return self._idx2key[item]

    def __len__(self):
        return len(self._idx2key)

    def __iter__(self):
        return (k for k in self._idx2key)

    def item(self):
        return self._idx2key